"""Which‑path meter with discrete overlap (symmetric construction)."""
from __future__ import annotations
from typing import Set, Tuple

def make_feature_sets(M: int, m: int) -> Tuple[Set[int], Set[int]]:
    base = list(range(1, M + 1))
    shared = set(base[:m])
    rem = base[m:]
    half = len(rem) // 2
    FU = shared | set(rem[:half])
    FL = shared | set(rem[half:])
    return FU, FL

def distinguishability_symmetric(M: int, m: int) -> float:
    # For symmetric sets of size Z = (M+m)/2 with intersection m
    # TV distance D = (M - m) / (M + m)
    if M + m == 0:
        return 0.0
    return (M - m) / (M + m)
